<!DOCTYPE html>
<html lang="en">
<head>
	<!-- Meta -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Awaiken Theme">
	
	<!-- Page Title -->
	<title>Mama'Smile Penguins - The Preschool & Daycare</title>
	<link rel="icon" type="image/x-icon" href="D:\Vishal\mamasmilepenguins\favicon\favicon.ico">
	<!-- Google Fonts css-->
	<link href="https://fonts.googleapis.com/css?family=Bubblegum+Sans|Roboto:300,400,500,700,900" rel="stylesheet">
	<!-- Bootstrap css -->
	<link href="css/bootstrap.min.css" rel="stylesheet" media="screen">
	<!-- Font Awesome icon css-->
	<link href="css/font-awesome.min.css" rel="stylesheet" media="screen">
	<link href="css/flaticon.css" rel="stylesheet" media="screen">
	<!-- Swiper's CSS -->
	<link rel="stylesheet" href="css/swiper.min.css">
	<!-- Animated css -->
	<link href="css/animate.css" rel="stylesheet">
	<!-- Magnific Popup CSS -->
	<link href="css/magnific-popup.css" rel="stylesheet">
	<!-- Slick nav css -->
	<link rel="stylesheet" href="css/slicknav.css">
	<!-- Main custom css -->
	<link href="css/custom.css" rel="stylesheet" media="screen">
	<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    <style>
	body{
	overflow-x: hidden;
	}
@keyframes bounce {
  0%, 20%, 50%, 80%, 100% {
    transform: translateY(0);
  }
  40% {
    transform: translateY(-10px);
  }
  60% {
    transform: translateY(-5px);
  }
}

.contact-icons {
  position: fixed;
  right: 20px;
  top: 50%;
  transform: translateY(-50%);
  background-color: #f1f1f1; /* Background color */
  padding: 10px;
  border: 1px solid #ccc; /* Border style */
}

.contact-icons a {
 display: flex;
  align-items: center;
  margin-bottom: 10px;
  font-size: 24px;
  text-decoration: none;
  transition: color 0.3s ease-in-out;
  color: #000; /* Icon color */
}
.contact-icons a:not(:last-child) {
  margin-right: 10px; /* Spacer between icons */
}

.contact-icons a:hover {
  color: #ff0000; /* Change color on hover */
}

.contact-icons .phone i {
  color: #27187E; /* Phone icon color */
}

.contact-icons .whatsapp i {
  color: #075E54; /* WhatsApp icon color */
}

.contact-icons .email i {
  color: #FF8600; /* Email icon color */
}

.contact-icons i {
  margin-left: 10px;
}



.brush:before {
  content:url(data:image/png;base64,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);
  position: absolute;
  display: block;
  margin-top: -10px;
  left: 0px;
  
  -webkit-animation: brush 6s 0s  backwards reverse;
  -moz-animation:    brush 6s 0s  backwards reverse;
  -o-animation:      brush 6s 0s  backwards reverse;
  animation:         brush 6s 0s  backwards reverse;  
  
  -webkit-mask:url(data:image/png;base64,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) no-repeat 0 0;
  mask:url(data:image/png;base64,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) no-repeat 0 0;
}

@-webkit-keyframes brush {
  0% {
    -webkit-mask-position: 0 0;
    mask-position: 0 0;
  }
  100% {
    -webkit-mask-position: 295px 0px;
    mask-position: 295px 0px;
  }
}
.first-ul li{
  list-style: none;
 padding-left: 50px;
  position: relative;
  margin-bottom: 10px;
  list-style: none;
  padding-top: 10px;
  padding-bottom:10px;
  font-family: 'Bubblegum Sans', cursive;
  font-size:18px;
  /*background-color: #fff4f1;  Background color */
 /* border-radius: 5px;  Rounded corners */
 /* box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);  Box shadow */
}

.first-ul li:before {
  content: "";
  position: absolute;
  
  left: 5px;
  display: inline-block;
  height: 30px;
  width: 30px;
  background-size: contain;
  background-image: url("images/arrow.png");
}


.multicolortext {
        background-image: linear-gradient(to left, #276FBF, #ED6A5A, #DBF4A7, #B24C63,#26532B, #F46771, #5ABCB9);
        -webkit-background-clip: text;
        -moz-background-clip: text;
        background-clip: text;
        color: transparent;
      }


    </style>
</head>
<body data-spy="scroll" data-target="#main-navbar" data-offset="71">
	<!-- Tob Bar Section Start -->
	<div class="top-bar">
		<div class="container">
			<div class="row">
				<div class="col-md-4">
					<div class="header-social-link">
						<a href="https://www.facebook.com/mamasmile.penguins" target="_blank"><i class="fa fa-facebook"></i></a>
						<a href="https://twitter.com/mama_penguins" target="_blank"><i class="fa fa-twitter"></i></a>
						<a href="https://www.linkedin.com/company/mama-smile-penguins/" target="_blank"><i class="fa fa-linkedin"></i></a>
						<a href="https://www.instagram.com/mamasmile.penguins/" target="_blank"><i class="fa fa-instagram"></i></a>
						<a href="https://in.pinterest.com/mamasmilepenguin/" target="_blank"><i class="fa fa-pinterest"></i></a>
						<a href="https://www.youtube.com/channel/UC7zhPAT1T8U2KNuU8LXMUEg" target="_blank"><i class="fa fa-youtube"></i></a>
					</div>
				</div>
				
				<div class="col-md-8 text-right">
					<div class="school-info">
						<ul>
							<li><a href="#"><i class="fa fa-envelope"></i> Email : mamasmile.penguin@gmail.com</a></li>
							<li><a href="#"><i class="fa fa-phone"></i> Call : +91 844-0007-899 | 850-5000-789</a></li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Tob Bar Section End -->
	
	<!-- Header Section Start -->
	<header class="header">
		<nav class="navbar navbar-expand-lg navbar-light" id="main-navbar">
			<div class="container">
				<!-- Navbar Brand start -->
				<a class="navbar-brand" href="#"><img src="images/logo2.png" alt="" /></a>
				<!-- Navbar Brand end -->
				
				<ul class="navbar-nav ml-auto" id="main-menu">
					<li class="nav-item"><a class="nav-link active" href="#home">Home</a></li>
					<li class="nav-item"><a class="nav-link" href="#programs">Programs</a></li>
					<li class="nav-item"><a class="nav-link" href="#activities">Features</a></li>
					<li class="nav-item"><a class="nav-link" href="#teachers">Teachers</a></li>
					<li class="nav-item"><a class="nav-link" href="#events">Events</a></li>
					<li class="nav-item"><a class="nav-link" href="#review">Testimonials</a></li>
					<li class="nav-item"><a class="nav-link" href="#gallery">Gallery</a></li>
					<li class="nav-item"><a class="nav-link" href="#contact">Contact</a></li>
				</ul>
					
				<div class="navbar-toggle"></div>
				<div id="responsive-menu"></div>
			</div>
		</nav>	
	</header>
	<!-- Header Section End -->
	
	<!-- Banner Slider Section starts -->
	<div class="banner-slider" id="home">
		<div class="container-fluid">
			<div class="row no-gutters">
				<div class="col-md-12">
					<div class="swiper-container banner-slider">
						<div class="swiper-wrapper">
							<!-- Header Slide start -->
							<div class="swiper-slide">
								<div class="banner-slide">
									<figure>
										<img src="images/slide-1.jpg">
									</figure>
									
									<div class="banner-slide-overlay">
										<h2 class="color-orange" data-swiper-animation="fadeInDown" data-duration="1s" data-delay="1.5s">Pre School - Nurturing Young Minds, One Giggle at a Time!</h2>
										<a href="#contact" class="btn-slider" data-swiper-animation="fadeInUp" data-duration="1s" data-delay="2.5s">Enroll Today !</a>
									</div>
								</div>
							</div>
							<!-- Header Slide end -->
							
							<!-- Header Slide start -->
							<div class="swiper-slide">
								<div class="banner-slide">
									<figure>
										<img src="images/slide-2.jpg">
									</figure>
									
									<div class="banner-slide-overlay" data-swiper-animation="zoomIn" data-duration="1s" data-delay="0.5s">
										<h2 class="color-green" data-swiper-animation="fadeInDown" data-duration="1s" data-delay="1.5s">Day Care: Where Love and Learning Bloom Every Day!</h2>
										<a href="#contact" class="btn-slider" data-swiper-animation="fadeInUp" data-duration="1s" data-delay="2.5s">Enroll Today !</a>
									</div>
								</div>
							</div>
							<!-- Header Slide end -->
							
							<!-- Header Slide start -->
							<div class="swiper-slide">
								<div class="banner-slide">
									<figure>
										<img src="images/slide-3.jpg">
									</figure>
									
									<div class="banner-slide-overlay" data-swiper-animation="zoomIn" data-duration="1s" data-delay="0.5s">
										<h2 class="color-blue" data-swiper-animation="fadeInDown" data-duration="1s" data-delay="1.5s">Unlocking Potential, Inspiring Futures After School!</h2>
										<a href="#contact" class="btn-slider" data-swiper-animation="fadeInUp" data-duration="1s" data-delay="2.5s">Enroll Today !</a>
									</div>
								</div>
							</div>
							<!-- Header Slide end -->
						</div>
						
						<!-- Banner Pagination start -->
						<div class="banner-button-prev"><i class="fa fa-chevron-left"></i></div>
						<div class="banner-button-next"><i class="fa fa-chevron-right"></i></div>
						<!-- Banner Pagination end -->
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Banner Slider Section ends -->
	
	<!--activities section deleted-->
	
	<!-- Our Programs Section Starts -->
	<section class="courses" id="programs">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section title start -->
					<div class="section-title">
						<h2 class="color-orange">Our Programs</h2>
						<p>Our Best Services for your Kids</p>
					</div>
					<!-- Section title end -->
				</div>
			</div>
			
			<div class="row">
				<div class="col-lg-4">
					<!-- Course Single Start -->
					<div class="course-single course-orange wow fadeInUp" data-wow-delay="0.3s">
						<figure>
							<img src="images/course-1.jpg" />
						</figure>
						
						<div class="course-body">
							<h3>Pre School</h3>
							<p>Discovering wonders, fostering growth, and igniting curiosity in our vibrant and nurturing preschool environment.</p>
						</div>
						
						<div class="course-footer">
							<a href="#contact">Apply Now</a>
							
						</div>
					</div>
					<!-- Course Single end -->
				</div>
				
				<div class="col-lg-4">
					<!-- Course Single Start -->
					<div class="course-single course-blue wow fadeInUp" data-wow-delay="0.6s">
						<figure>
							<img src="images/course-2.jpg" />
						</figure>
						
						<div class="course-body">
							<h3>Day Care</h3>
							<p>A safe haven of care, love, and endless exploration, where little ones thrive and create cherished memories.</p>
						</div>
						
						<div class="course-footer">
							<a href="#contact">Apply Now</a>
							
						</div>
					</div>
					<!-- Course Single End -->
				</div>
				
				<div class="col-lg-4">
					<!-- Course Single Start -->
					<div class="course-single course-green wow fadeInUp" data-wow-delay="0.9s">
						<figure>
							<img src="images/course-3.jpg" />
						</figure>
						
						<div class="course-body">
							<h3>After School</h3>
							<p>A vibrant hub of learning, creativity, and friendship, empowering children to grow, excel, and shine after school.</p>
						</div>
						
						<div class="course-footer">
							<a href="#contact">Apply Now</a>
							
						</div>
					</div>
					<!-- Course Single End -->
				</div>
			</div>
			
		</div>
		
	</section>
	<section class="about-us">
	<div class="container">
	<div class="row">
				<div class="col-md-12">
					<!-- Section title start -->
					<div class="section-title">
						<h2 class="color-orange">Program Features</h2>
						<p>Unlocking Potential, Empowering Minds</p>
					</div>
					<!-- Section title end -->
				</div>
			</div>
		<div class="row" style="margin-top:20px !important;">
			<div class="col-md-4">
					<!-- About Image Start -->
					<div class="about-image wow fadeInLeft" data-wow-delay="0.3s">
						<img src="images/preschool.jpg" />
					</div>
					<!-- About Image End -->
			</div>
				
			<div class="col-md-8">
				<!-- About Content Start -->
				<div class="about-content wow fadeInUp" data-wow-delay="0.6s">
					<h3 class="brush">Pre School</h3>
					<p style="font-size:20px;text-align:center;font-family: 'Bubblegum Sans', cursive;">
					<span style="color:#44344F;">Age Group : </span>
					<span style="color:#ff5722;">1.5 - 6 Years</span> | 
					<span style="color:#44344F;">Timings : </span>
					<span style="color:#ff5722;">9:30 AM – 12:30 PM </span></p>
					
					<p style="text-align:justify;">Mama'Smile Penguins Kids School is a reputable preschool and Day Care school in Vaishali Nagar, Jaipur. 
					With a strong focus on early childhood education, Mama'Smile Penguins School offers a nurturing and engaging environment 
					for children to thrive. </p><p style="text-align:justify;">They provide comprehensive day care services and cater to kids of varying age groups. 
					As the best prepratary school, it is dedicated to offering a well-rounded curriculum that promotes holistic development, 
					including cognitive, social, emotional, and physical growth. With a team of experienced and caring educators, Mama'Smile Penguins School 
					ensures individual attention and a safe learning environment. It is an ideal choice for parents seeking a quality 
					preparatory school for their children.</p>
					</div>
				
			</div>
			<div class="col-md-8">
					<p style="font-size:20px;text-align:center;color:#ff5722;font-family: 'Bubblegum Sans', cursive;margin-bottom:0px!important;">The Fundamental Principles Guiding an Exemplary Education System<img src="images/fish.webp" width="50" height="50"></p>
					
					<p>
					<ul class="first-ul">
					<li class="wow fadeInLeft" style="animation-delay: 0.7s; animation-name: fadeInLeft;">
					<font color="#26532B">Multiple engaging</font> 
					<font color="#F46771">ways for</font> 
					<font color="#5ABCB9">In-Depth Understanding</font> 
					<font color="#276FBF">of Select Topics</font> </li>
					<li class="wow fadeInLeft" style="animation-delay: 0.9s; animation-name: fadeInLeft;">
					<font color="#276FBF">Active</font>
					<font color="#F46771">Participation</font></li>
					<li class="wow fadeInLeft" style="animation-delay: 0.9s; animation-name: fadeInLeft;">
					<font color="#5ABCB9">Emphasizing Learning</font>
					<font color="#F46771">Rather Than </font>
					<font color="#276FBF">Excessive Homework</font>
					<font color="#26532B">and Testing</font></li>
					<li class="wow fadeInLeft" style="animation-delay: 1.3s; animation-name: fadeInLeft;">
					<font color="#F46771">Smaller Class</font>
					<font color="#276FBF">Sizes for</font>
					<font color="#26532B">individualized</font>
					<font color="#5ABCB9">Attention</font></li>
					</ul>
					</p>
					
			</div>
			<div class="col-md-4" style="padding:50px;">
					<!-- About Image Start -->
					<div class="about-image wow fadeInRight" data-wow-delay="0.3s">
						<img src="images/preschool1.png" width="300" height="300" />
					</div>
					<!-- About Image End -->
			</div>
			
		</div>
		
		<div class="row" style="margin-top:20px !important;">
			<div class="col-md-8">
				<!-- About Content Start -->
				<div class="about-content wow fadeInUp" data-wow-delay="0.6s">
					<h3 class="brush">Day Care</h3><img src="images/sun.gif" width="50" height="50">
					
					<p style="text-align:justify;">At our daycare, we prioritize creating a warm and secure environment where your child's well-being and 
					development are our top priorities. Our experienced caregivers provide nurturing care, engaging activities, 
					and educational opportunities tailored to each child's needs. We encourage social interaction, creativity, 
					and independent thinking, fostering a sense of belonging and building a strong foundation for lifelong learning. 
					Trust us to provide a loving home away from home for your little one..</p>
					
					<p style="text-align:justify;">Our daycare is equipped with age-appropriate toys, stimulating play areas, and a structured routine that 
					promotes healthy habits and cognitive growth. We maintain open communication with parents, ensuring peace of 
					mind and collaboration in your child's journey. Together, we create a nurturing and supportive environment where children flourish.</p>
				</div>
				<!-- About Content End -->
				
				<!-- About Social Link Starts -->
				<!--<div class="about-social-links">
					<a href="#"><i class="fa fa-facebook"></i></a>
					<a href="#"><i class="fa fa-twitter"></i></a>
					<a href="#"><i class="fa fa-linkedin"></i></a>
					<a href="#"><i class="fa fa-instagram"></i></a>
				</div>-->
				<!-- About Social Link Ends -->
			</div>
			<div class="col-md-4">
					<!-- About Image Start -->
					<div class="about-image wow fadeInLeft" data-wow-delay="0.3s">
						<img src="images/daycare1.jpg" width="350" height="350"/>
					</div>
					<!-- About Image End -->
			</div>
				
			
		</div>
		<div class="row" style="margin-top:20px !important;">
			<div class="col-md-4">
					<!-- About Image Start -->
					<div class="about-image wow fadeInLeft" data-wow-delay="0.3s">
						<img src="images/aftrschool.jpg" />
					</div>
					<!-- About Image End -->
			</div>
				
			<div class="col-md-8">
				<!-- About Content Start -->
				<div class="about-content wow fadeInUp" data-wow-delay="0.6s">
					<h3 class="brush">After School</h3>
					
					<p style="text-align:justify;">At our after-school program, we go beyond homework help to provide a dynamic space where children 
					can explore their passions and discover new interests. Our dedicated staff offers a diverse range of 
					enriching activities, from arts and crafts to sports and STEM projects. We foster teamwork, critical 
					thinking, and resilience, empowering children to develop essential life skills. 
					</p>
					
					<p style="text-align:justify;">With a focus on individualized attention and a positive atmosphere, we strive to create a welcoming community 
					where children feel inspired, confident, and supported in their after-school endeavors. Together, we unlock their full 
					potential and lay the groundwork for future success.</p>
				</div>
				<!-- About Content End -->
				
				<!-- About Social Link Starts -->
				<!--<div class="about-social-links">
					<a href="#"><i class="fa fa-facebook"></i></a>
					<a href="#"><i class="fa fa-twitter"></i></a>
					<a href="#"><i class="fa fa-linkedin"></i></a>
					<a href="#"><i class="fa fa-instagram"></i></a>
				</div>-->
				<!-- About Social Link Ends -->
			</div>
		</div>
	</div>
	</section>
	<!-- Our Programs Section Ends -->
	
	<!---about us section deleted-->
	
	<!-- Faculty Section starts -->
	<section class="faculty" id="teachers">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section title start -->
					<div class="section-title">
						<h2 class="color-orange">Qualified Teachers</h2>
						<p>Guiding Little Minds with Expertise and Care!</p>
					</div>
					<!-- Section title end -->
				</div>
			</div>
			
			<div class="row">
				<div class="col-lg-3 col-md-6">
					<!-- Faculty Single Start -->
					<div class="faculty-single faculty-orange wow fadeInUp" data-wow-delay="0.3s">
						<figure>
							<img src="images/team-1.jpg" />
						</figure>
						
						<div class="faculty-info">
							<h3>Alison Silva</h3>
							<p>Music Teacher</p>
						</div>
					</div>
					<!-- Faculty Single End -->
				</div>
				
				<div class="col-lg-3 col-md-6">
					<!-- Faculty Single Start -->
					<div class="faculty-single faculty-blue wow fadeInUp" data-wow-delay="0.6s">
						<figure>
							<img src="images/team-2.jpg" />
						</figure>
						
						<div class="faculty-info">
							<h3>Jack Edward</h3>
							<p>Maths Teacher</p>
						</div>
					</div>
					<!-- Faculty Single End -->
				</div>
				
				<div class="col-lg-3 col-md-6">
					<!-- Faculty Single Start -->
					<div class="faculty-single faculty-green wow fadeInUp" data-wow-delay="0.9s">
						<figure>
							<img src="images/team-3.jpg" />
						</figure>
						
						<div class="faculty-info">
							<h3>Terri Mastrang</h3>
							<p>Science Teacher</p>
						</div>
					</div>
					<!-- Faculty Single End -->
				</div>
				
				<div class="col-lg-3 col-md-6">
					<!-- Faculty Single Start -->
					<div class="faculty-single faculty-orange wow fadeInUp" data-wow-delay="1.2s">
						<figure>
							<img src="images/team-4.jpg" />
						</figure>
						
						<div class="faculty-info">
							<h3>Krystal Hickman</h3>
							<p>Sports Teacher</p>
						</div>
					</div>
					<!-- Faculty Single End -->
				</div>
			</div>
		</div>
	</section>
	<!-- Faculty Section Ends -->
	
	<!-- Upcoming Events Section Starts -->
	<section class="events" id="events">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section title start -->
					<div class="section-title">
						<h2 class="color-orange">Upcoming Events</h2>
						<p>Embrace the Excitement: Unforgettable Experiences Await!</p>
					</div>
					<!-- Section title end -->
				</div>
			</div>
			
			<div class="row">
				<div class="col-md-12">
					<div class="swiper-container event-slider">
						<div class="swiper-wrapper">
							<!-- Event Single Slide start -->
							<div class="swiper-slide">
								<div class="event-single event-orange">
									<figure>
										<img src="images/event-1.jpg" alt="" />
										<div class="date"><span>06</span> Dec - 18</div>
									</figure>
									
									<div class="event-body">
										<h3>Outdor Music Event</h3>
										<p class="location">Vaishali Nagar, Jaipur</p>
										<p class="time">9:00 AM to 12:00 PM</p>
									</div>
								</div>
							</div>
							<!-- Event Single Slide end -->
							
							<!-- Event Single Slide start -->
							<div class="swiper-slide">
								<div class="event-single event-blue">
									<figure>
										<img src="images/event-2.jpg" alt="" />
										<div class="date"><span>06</span> Dec - 18</div>
									</figure>
									
									<div class="event-body">
										<h3>Outdor Music Event</h3>
										<p class="location">Kids Hall, Jaipur</p>
										<p class="time">9:00 AM to 12:00 PM</p>
									</div>
								</div>
							</div>
							<!-- Event Single Slide end -->
							
							<!-- Event Single Slide start -->
							<div class="swiper-slide">
								<div class="event-single event-green">
									<figure>
										<img src="images/event-3.jpg" alt="" />
										<div class="date"><span>06</span> Dec - 18</div>
									</figure>
									
									<div class="event-body">
										<h3>Outdor Music Event</h3>
										<p class="location">School Campus, Jaipur</p>
										<p class="time">9:00 AM to 12:00 PM</p>
									</div>
								</div>
							</div>
							<!-- Event Single Slide end -->
						</div>
						
						<!-- Event Pagination start -->
						<div class="event-pagination"></div>
						<!-- Event Pagination end -->
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Upcoming Events Section Ends -->
	
	<!-- Testimonial Section Starts -->
	<section class="testimonial" id="review">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section title start -->
					<div class="section-title">
						<h2 class="color-orange">Parents Testimonial</h2>
						<p>Hear the Love and Joy of Our Happy Families!</p>
					</div>
					<!-- Section title end -->
				</div>
			</div>
			
			<div class="row">
				<div class="col-md-12">
					<div class="testimonial-slider-wrapper-outer">
						<div class="testimonial-slider-wrapper">
							<div class="swiper-container testimonial-slider">
								<div class="swiper-wrapper">
									<!-- Testimonial Slide start -->
									<div class="swiper-slide">
										<div class="testimonial-slide">
											<figure>
												<img src="images/team-4.jpg" alt="" />
											</figure>
											
											<h3>Kusum Gupta</h3>
											<p>"Enrolling my child in this preschool was the best decision I ever made. The nurturing environment, dedicated teachers, and engaging curriculum have transformed my child's love for learning. I can't recommend it enough!"</p>
										</div>
									</div>
									<!-- Testimonial Slide end -->
									
									<!-- Testimonial Slide start -->
									<div class="swiper-slide">
										<div class="testimonial-slide">
											<figure>
												<img src="images/team-4.jpg" alt="" />
											</figure>
											
											<h3>Manisha Trilok</h3>
											<p>"As a working parent, finding a daycare that feels like a second home was a top priority. The loving care, stimulating activities, and open communication at this center have given me complete peace of mind. My child loves going there every day!"</p>
										</div>
									</div>
									<!-- Testimonial Slide end -->
									
									<!-- Testimonial Slide start -->
									<div class="swiper-slide">
										<div class="testimonial-slide">
											<figure>
												<img src="images/team-4.jpg" alt="" />
											</figure>
											
											<h3>Amita Srivastava</h3>
											<p>"The after-school program here has been a game-changer for my child. Not only have they excelled academically with homework assistance, but they've also discovered new passions through the wide variety of activities offered. The caring staff has truly made a positive impact on their growth and self-confidence."</p>
										</div>
									</div>
									<!-- Testimonial Slide end -->
								</div>

								<!-- Testimonial Pagination start -->
								<div class="testimonial-pagination"></div>
								<!-- Testimonial Pagination end -->
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Testimonial Section Ends -->
	
	<!-- Photo Gallery Section Starts -->
	<section class="photo-gallery" id="gallery">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Section title start -->
					<div class="section-title">
						<h2 class="color-orange">Photo Gallery</h2>
						<p>A Glimpse into Our Journey of Smiles, Discoveries, and Cherished Memories.</p>
					</div>
					<!-- Section title end -->
				</div>
			</div>
			
			<div class="row gallery">
				<div class="col-lg-3 col-md-4 col-sm-6">
					<!-- Photo Gallery Single start -->
					<div class="photo-single photo-orange wow fadeInUp" data-wow-delay="0.3s">
						<a href="images/course-1.jpg"><img src="images/course-1.jpg" /></a>
					</div>
					<!-- Photo Gallery Single end -->
				</div>
				
				<div class="col-lg-3 col-md-4 col-sm-6">
					<!-- Photo Gallery Single start -->
					<div class="photo-single photo-blue wow fadeInUp" data-wow-delay="0.6s">
						<a href="images/course-2.jpg"><img src="images/course-2.jpg" /></a>
					</div>
					<!-- Photo Gallery Single end -->
				</div>
				
				<div class="col-lg-3 col-md-4 col-sm-6">
					<!-- Photo Gallery Single start -->
					<div class="photo-single photo-green wow fadeInUp" data-wow-delay="0.9s">
						<a href="images/course-3.jpg"><img src="images/course-3.jpg" /></a>
					</div>
					<!-- Photo Gallery Single end -->
				</div>
				
				<div class="col-lg-3 col-md-4 col-sm-6">
					<!-- Photo Gallery Single start -->
					<div class="photo-single photo-orange wow fadeInUp" data-wow-delay="1.2s">
						<a href="images/event-1.jpg"><img src="images/event-1.jpg" /></a>
					</div>
					<!-- Photo Gallery Single end -->
				</div>
				
				<div class="col-lg-3 col-md-4 col-sm-6">
					<!-- Photo Gallery Single start -->
					<div class="photo-single photo-blue wow fadeInUp" data-wow-delay="1.5s">
						<a href="images/event-2.jpg"><img src="images/event-2.jpg" /></a>
					</div>
					<!-- Photo Gallery Single end -->
				</div>
				
				<div class="col-lg-3 col-md-4 col-sm-6">
					<!-- Photo Gallery Single start -->
					<div class="photo-single photo-green wow fadeInUp" data-wow-delay="1.8s">
						<a href="images/event-3.jpg"><img src="images/event-3.jpg" /></a>
					</div>
					<!-- Photo Gallery Single end -->
				</div>
				
				<div class="col-lg-3 col-md-4 col-sm-6">
					<!-- Photo Gallery Single start -->
					<div class="photo-single photo-orange wow fadeInUp" data-wow-delay="2.1s">
						<a href="images/course-1.jpg"><img src="images/course-1.jpg" /></a>
					</div>
					<!-- Photo Gallery Single end -->
				</div>
				
				<div class="col-lg-3 col-md-4 col-sm-6">
					<!-- Photo Gallery Single start -->
					<div class="photo-single photo-blue wow fadeInUp" data-wow-delay="2.4s">
						<a href="images/course-2.jpg"><img src="images/course-2.jpg" /></a>
					</div>
					<!-- Photo Gallery Single end -->
				</div>
			</div>
		</div>
	</section>
	<!-- Photo Gallery Section Ends -->
	<div class="row">
		
			<div class="col-md-12" style="overflow-x: hidden;margin-top:-140px;background-image: url(images/grass.png);background-repeat: repeat-x;">
			</div>
		
	</div>
	<!-- Contact us Section Starts -->
	<section class="contactus" id="contact">
		<div class="container">
			<div class="row">
				<div class="col-md-6">
					<!-- Section title start -->
					<div class="section-title">
						<h2 class="color-orange">Information</h2>
						<p>Uncover the Insights and Expertise That Will Propel You Forward</p>
					</div>
					<!-- Section title end -->
					
					<!-- Contact info start -->
					<div class="contact-info">
						<p class="email">mamasmile.penguin@gmail.com</p>
						<p class="contact">844-0007-899 | 850-5000-789</p>
						<p class="address">28, L.N. Nagar, Gandhi Path, Prithviraj Nagar, Jaipur (Raj.)</p>
					</div>
					<!-- Contact info End -->
					
					<!-- Contact Social Link start -->
					<div class="contact-social-link">
						<a href="https://www.facebook.com/mamasmile.penguins" target="_blank"><i class="fa fa-facebook"></i></a>
						<a href="https://twitter.com/mama_penguins" target="_blank"><i class="fa fa-twitter"></i></a>
						<a href="https://www.linkedin.com/company/mama-smile-penguins/" target="_blank"><i class="fa fa-linkedin"></i></a>
						<a href="https://www.instagram.com/mamasmile.penguins/" target="_blank"><i class="fa fa-instagram"></i></a>
						<a href="https://in.pinterest.com/mamasmilepenguin/" target="_blank"><i class="fa fa-pinterest"></i></a>
						<a href="https://www.youtube.com/channel/UC7zhPAT1T8U2KNuU8LXMUEg" target="_blank"><i class="fa fa-youtube"></i></a>
					</div>
					<!-- Contact Social Link end -->
				</div>
				
				<div class="col-md-6">
					<!-- Section title start -->
					<div class="section-title">
						<h2 class="color-orange">Contact Us</h2>
						<p>Reach Out Today and Discover How We Can Shape a Bright Future Together!</p>
					</div>
					<!-- Section title end -->
					
					<!-- Contact Form start -->
					<div class="contact-form">
						<form id="contactForm" action="#" method="post">
							<div class="row">
								<div class="form-group col-md-6 col-sm-6">
									<input type="text" class="form-control" placeholder="Your Name" />
								</div>
								
								<div class="form-group col-md-6 col-sm-6">
									<input type="number" class="form-control" placeholder="Your Mobile" />
								</div>
								
								<div class="form-group col-md-12 col-sm-12">
									<input type="email" class="form-control" placeholder="Your Email Address" />
								</div>
								
								<div class="form-group col-md-12 col-sm-12">
									<input type="text" class="form-control" placeholder="Subject">
								</div>
								
								<div class="form-group col-md-12 col-sm-12">
<textarea rows="4"class="form-control" placeholder="How can i help you?"></textarea>
								</div>
								
								<div class="col-md-12 col-sm-12 text-center">
									<button type="submit" class="btn-contact">Submit</button>
								</div>
							</div>
						</form>
					</div>
					<!-- Contact Form end -->
				</div>
			</div>
		</div>
	</section>
	<!-- Contact us Section Ends -->
<div class="contact-icons">
  <a href="tel:1234567890" class="animated-icon phone">
    <i class="fa fa-phone"></i>
  </a>
  <a href="https://api.whatsapp.com/send?phone=1234567890" target="_blank" rel="noopener noreferrer" class="animated-icon whatsapp">
    <i class="fa fa-whatsapp"></i>
  </a>
  <a href="mailto:example@example.com" class="animated-icon email">
    <i class="fa fa-envelope"></i>
  </a>
</div>




	<!-- Footer Section Starts -->
	<footer class="footer">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<!-- Footer logo start -->
					<div class="footer-logo">
						<img src="images/logo2.png" alt="" />
					</div>
					<!-- Footer logo end -->
					
					<!-- Footer Copyright start -->
					<div class="footer-copyright">
						<p>Copyright &copy; mama'smilepenguins. All rights reserved. Design By <a href="https://awaikenthemes.com/" target="_blank">Awaiken Theme</a> 
						Images <a href="https://unsplash.com/" target="_blank">Unsplash</a>, 
						<a href="https://pixabay.com/" target="_blank">Pixabay</a>, <a href="http://www.freepik.com" target="_blank">Freepik</a>, 
						Icon <a href="https://www.flaticon.com/" target="_blank">Flaticon</a></p>
						
					</div>
					<!-- Footer Copyright end -->
				</div>
			</div>
		</div>
	</footer>
	<!-- Footer Section Ends -->
	
	<!-- Jquery Library File -->
	<script src="js/jquery-1.12.4.min.js"></script>
	<!-- Bootstrap js file -->
	<script src="js/bootstrap.min.js"></script>
	<!-- Wow js file -->
	<script src="js/wow.js"></script>
	<!-- Swiper Carousel js file -->
	<script src="js/swiper.min.js"></script>
	<script src="js/SwiperAnimation.min.js"></script>
	<!-- Magnific Popup core JS file -->
	<script src="js/jquery.magnific-popup.min.js"></script>
	<!-- Slick Nav js file -->
	<script src="js/jquery.slicknav.js"></script>
	<!-- SmoothScroll -->
	<script src="js/SmoothScroll.js"></script>
    <!-- Main Custom js file -->
	<script src="js/function.js"></script>
	
</body>
</html>